/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.dialogs;

import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.dialogs.Messages;
import java.util.Set;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateBranchDialog
extends InputDialog {
    private GitRepository repo;
    private Text startPointText;
    private Button trackButton;
    private boolean track;
    private String startPoint;
    private boolean autoTrack = true;

    public CreateBranchDialog(Shell parentShell, final GitRepository repo) {
        super(parentShell, Messages.CreateBranchDialog_CreateBranchDialog_Title, Messages.CreateBranchDialog_CreateBranchDialog_Message, "", new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || newText.trim().length() == 0) {
                    return Messages.CreateBranchDialog_NonEmptyBranchNameMessage;
                }
                if (newText.trim().contains(" ") || newText.trim().contains("\t")) {
                    return Messages.CreateBranchDialog_NoWhitespaceBranchNameMessage;
                }
                if (repo.localBranches().contains(newText.trim())) {
                    return Messages.CreateBranchDialog_BranchAlreadyExistsMessage;
                }
                if (!repo.validRefName("refs/heads/" + newText.trim())) {
                    return Messages.CreateBranchDialog_InvalidBranchNameMessage;
                }
                return null;
            }
        });
        this.repo = repo;
        this.autoTrack = repo.autoSetupMerge();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Group group = new Group(composite, -1);
        group.setText(Messages.CreateBranchDialog_AdvancedOptions_label);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.CreateBranchDialog_StartPoint_label);
        this.startPointText = new Text((Composite)group, this.getInputTextStyle());
        this.startPointText.setText(this.repo.headRef().simpleRef().shortName());
        this.startPointText.setLayoutData((Object)new GridData(768));
        this.startPointText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateBranchDialog.this.startPoint = CreateBranchDialog.this.startPointText.getText();
                if (CreateBranchDialog.this.startPoint.indexOf(47) != -1 && CreateBranchDialog.this.autoTrack) {
                    for (String remoteName : CreateBranchDialog.this.repo.remotes()) {
                        if (!CreateBranchDialog.this.startPoint.startsWith(String.valueOf(remoteName) + '/')) continue;
                        CreateBranchDialog.this.trackButton.setSelection(true);
                        CreateBranchDialog.this.track = true;
                        break;
                    }
                }
            }
        });
        Set simpleRefs = this.repo.allSimpleRefs();
        String[] proposals = simpleRefs.toArray(new String[simpleRefs.size()]);
        new AutoCompleteField((Control)this.startPointText, (IControlContentAdapter)new TextContentAdapter(), proposals);
        SimpleContentProposalProvider proposalProvider = new SimpleContentProposalProvider(proposals);
        proposalProvider.setFiltering(true);
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.startPointText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)proposalProvider, KeyStroke.getInstance((int)262144, (int)32), null);
        adapter.setPropagateKeys(true);
        adapter.setProposalAcceptanceStyle(2);
        ControlDecoration decoration = new ControlDecoration((Control)this.startPointText, 16384);
        decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage());
        this.trackButton = new Button((Composite)group, 32);
        this.trackButton.setText(Messages.CreateBranchDialog_Track_label);
        this.trackButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateBranchDialog.this.track = CreateBranchDialog.this.trackButton.getSelection();
                CreateBranchDialog.this.autoTrack = false;
            }
        });
        return composite;
    }

    public boolean track() {
        return this.track;
    }

    public String getStartPoint() {
        return this.startPoint;
    }
}

